<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Ultimate_AI_Activity{
    private $history_manager, $USER_MANAGER, $UAI_SUBSCRIPTION;
    public function __construct(){}


    // $data= [
    //     'subject_id' = 1, //FROM :USER_ID        
    //     'object_id' = 1, //TO : USER_ID        
    //     'action_type' = 'PURCHASE', //PURCHASE, EDIT, MENTION, REQUEST,         
    //     'object_type' = 'SUBSCRIPTION',  //SUBSCRIPTION, INVOICE, CHAT, IMAGES, CODE      
    //     'object_name' = 'Unlimited plan',        
    // ]
    public function createActivity($data){
        $title = '';
        $user_info = get_userdata($data['subject_id']);
        $name = $user_info->display_name;

        $action_type_text = '';
        switch($data['action_type']){
            case "PURCHASE":
                $action_type_text = " Purchased ";
                break;
            case "EDIT":
                $action_type_text = " wants to edit ";
                break;
            case "MENTION":
                $action_type_text = " mentioned ";
                break;
        }

        $title = '<strong>' . $name . '</strong>' . $action_type_text . '<strong>' . $data['object_name'] . '</strong>';

        $post = [
            'post_author'   => $data['subject_id'],
            'post_title'    => $title,
            'post_status'   => 'private',
            'post_type'     => 'ultimate_ai_activity',
            'meta_input' => array(
                'subject_id'        => $data['subject_id'],
                'action_type'       => $data['action_type'],
                'object_type'       => $data['object_type'],
                'object_name'       => $data['object_name'],
            )
        ];

        $activity_id = wp_insert_post( $post );
        if( !is_wp_error( $activity_id ) ){
            return $activity_id;
        }else{
            return $activity_id;
        }
    }

    public function get_latest_activities( $limit, $offset ){
        return $this->filterActivities([
            'limit' => $limit,
            'offset' => $offset,
        ]);
    }

    public function filterActivities($data = []){
        $limit = isset($data['limit']) ? $data['limit'] : -1;
        $offset = isset($data['offset']) ? $data['offset'] : 0;
        $start = isset($data['start']) ? $data['start'] : '';
        $end = isset($data['end']) ? $data['end'] : '';
        $args = array(
            'post_status' => 'private',
            'post_type' => 'ultimate_ai_activity',
            'fields' => 'ids',
            'posts_per_page' => intval($limit),
            'offset' => intval($offset),
        );

        if( $start !== '' && $end !== '' ){
            $args['date_query'] = array(
                array(
                    'after'     => $start,
                    'before'    => $end,
                    'inclusive' => true,
                )
            );
        }
        $activities = new WP_Query( $args );
        $all_activities = [];

        $post_data = [];
        if( $activities->have_posts() ){
            while ( $activities->have_posts() ) {
                $activities->the_post();
                $post_data['id'] = get_the_ID();
                $post_data['date'] = get_the_date( 'Y-m-d' );
                $post_data['time_ago'] = human_time_diff(get_post_time('U'), current_time('timestamp')) . " " . __('ago');
                $post_data['title'] = get_the_title();
                $post_data['avatar_url'] = get_avatar_url( get_the_author_ID(), [ 'size' => 64 ] );

                $all_activities[] = $post_data;
            }
        }
        return $all_activities;
    }
}